<?php
require_once __DIR__ . '/../app/auth.php';
require_once __DIR__ . '/../app/db.php';
require_once __DIR__ . '/../app/helpers.php';

$modules = bi_modules();
$moduleKey = current_module_key();
if (auth_user()) {
    $_SESSION['module'] = $moduleKey;
}

$p = (string)($_GET['p'] ?? '');
$user = auth_user();

if ($p === '') {
    $p = $user ? (current_module()['default_page'] ?? 'dashboard') : 'login';
}

if (!$user && $p !== 'login') {
    header('Location: ' . route_url('login', ['m' => $moduleKey]));
    exit;
}

$publicPages = [
    'login' => __DIR__ . '/../app/pages/login.php',
    'logout' => __DIR__ . '/../app/pages/logout.php',
];

if (isset($publicPages[$p])) {
    require_once $publicPages[$p];
    exit;
}

$module = current_module();
$modulePages = $module['pages'] ?? [];
if (isset($modulePages[$p]['file']) && is_file($modulePages[$p]['file'])) {
    require_once $modulePages[$p]['file'];
    exit;
}

http_response_code(404);
echo 'Pagina nao encontrada.';
