<?php
require_auth();
require __DIR__ . '/_layout_top.php';

$pdo = db();

$mes = $_GET['mes'] ?? '';
$cliente = trim($_GET['cliente'] ?? '');
$op = trim($_GET['op'] ?? '');

$where = [];
$params = [];
if ($mes) {
  $ini = $mes . '-01';
  $fim = date('Y-m-t', strtotime($ini));
  $where[] = 'dt_producao BETWEEN ? AND ?';
  $params[] = $ini;
  $params[] = $fim;
}
if ($cliente) {
  $where[] = 'cliente LIKE ?';
  $params[] = '%' . $cliente . '%';
}
if ($op) {
  $where[] = 'op_trimb LIKE ?';
  $params[] = '%' . $op . '%';
}

$sql = 'SELECT * FROM bi_perdas' . ($where ? ' WHERE ' . implode(' AND ', $where) : '') . ' ORDER BY dt_producao DESC, id DESC LIMIT 400';
$st = $pdo->prepare($sql);
$st->execute($params);
$rows = $st->fetchAll();
?>
<section class="glass-card p-5 md:p-6">
  <div class="flex flex-wrap items-center justify-between gap-3">
    <div>
      <p class="text-xs uppercase tracking-[0.15em] text-mnc-muted">Registros</p>
      <h1 class="mt-1 text-2xl font-extrabold">Perdas Cadastradas</h1>
    </div>
    <a class="btn-primary" href="<?= e(route_url('perdas_form')) ?>">Novo Registro</a>
  </div>

  <form method="get" action="index.php" class="mt-4 grid gap-2 md:grid-cols-5">
    <input type="hidden" name="p" value="perdas">
    <input type="hidden" name="m" value="<?= e(current_module_key()) ?>">
    <input type="month" class="input-dark" name="mes" value="<?= e($mes) ?>">
    <input type="text" class="input-dark md:col-span-2" name="cliente" placeholder="Cliente" value="<?= e($cliente) ?>">
    <input type="text" class="input-dark" name="op" placeholder="OP / Trimb" value="<?= e($op) ?>">
    <button class="btn-muted">Filtrar</button>
  </form>
</section>

<section class="glass-card mt-4 overflow-hidden dt-grid-wrap">
  <div class="overflow-x-auto">
    <table class="table-dark min-w-[980px]" id="dtPerdasList">
      <thead>
        <tr>
          <th>Data</th>
          <th>OP</th>
          <th>Cliente</th>
          <th class="text-right">Pedido</th>
          <th class="text-right">Previsto</th>
          <th class="text-right">Realizado</th>
          <th class="text-right">Perda</th>
          <th class="text-right">% Perda</th>
          <th></th>
        </tr>
      </thead>
      <tbody>
      <?php foreach ($rows as $r): ?>
        <tr>
          <td><?= e(date('d/m/Y', strtotime($r['dt_producao']))) ?></td>
          <td><?= e($r['op_trimb']) ?></td>
          <td><?= e($r['cliente']) ?></td>
          <td class="text-right"><?= e($r['pedido']) ?></td>
          <td class="text-right"><?= e(money($r['valor_total_previsto'])) ?></td>
          <td class="text-right"><?= e(money($r['valor_total_realizado'])) ?></td>
          <td class="text-right font-bold text-cyan-700"><?= e($r['perda_total']) ?></td>
          <td class="text-right"><?= e(num($r['perc_perda'], 2)) ?>%</td>
          <td class="text-right">
            <a class="btn-muted px-3 py-1 text-xs" href="<?= e(route_url('perdas_form', ['id' => (int)$r['id']])) ?>">Editar</a>
          </td>
        </tr>
      <?php endforeach; ?>
      <?php if (!$rows): ?>
        <tr>
          <td colspan="9" class="py-8 text-center text-sm text-mnc-muted">Nenhum registro encontrado.</td>
        </tr>
      <?php endif; ?>
      </tbody>
    </table>
  </div>
  <div class="border-t border-slate-200 px-5 py-3 text-xs text-mnc-muted">Mostrando ate 400 registros.</div>
</section>

<script>
(function () {
  if (!window.DataTable) return;
  new DataTable('#dtPerdasList', {
    pageLength: 25,
    lengthMenu: [10, 25, 50, 100],
    order: [[0, 'desc']],
    language: {
      search: 'Buscar:',
      lengthMenu: 'Mostrar _MENU_',
      info: 'Mostrando _START_ a _END_ de _TOTAL_',
      infoEmpty: 'Sem registros',
      emptyTable: 'Sem dados no periodo',
      paginate: { first: 'Primeiro', previous: 'Anterior', next: 'Proximo', last: 'Ultimo' }
    }
  });
})();
</script>

<?php require __DIR__ . '/_layout_bottom.php'; ?>
