<?php
require_auth();
require __DIR__ . '/_layout_top.php';

$pdo = db();
$id = (int)($_GET['id'] ?? 0);

$default = [
  'dt_producao' => date('Y-m-d'),
  'op_trimb' => '',
  'cliente' => '',
  'pedido' => 0,
  'valor_unitario' => '',
  'valor_total_previsto' => '',
  'realizado' => 0,
  'valor_total_realizado' => '',
  'material' => '',
  'chapa_reservada_faturada' => 0,
  'contador_alimentacao' => 0,
  'conferencia' => 0,
  'perda_setup' => 0,
  'abaulada' => 0,
  'impressao_nao_conforme' => 0,
  'materia_prima' => 0,
  'acabou_cola' => 0,
  'acabou_tinta' => 0,
  'delaminacao' => 0,
  'fora_de_esquadro' => 0,
  'rasgada' => 0,
  'enroscou' => 0,
  'outros' => 0,
  'justificativa_outros' => '',
  'perda_total' => 0,
  'perc_perda' => 0,
  'diferenca_alimentacao' => 0,
];

$row = $default;
if ($id) {
  $st = $pdo->prepare('SELECT * FROM bi_perdas WHERE id=? LIMIT 1');
  $st->execute([$id]);
  $dbRow = $st->fetch();
  if ($dbRow) {
    $row = array_merge($row, $dbRow);
  }
}

function fnum($v) {
  $v = trim((string)$v);
  if ($v === '') return null;
  $v = str_replace(['.', ' '], ['', ''], $v);
  $v = str_replace(',', '.', $v);
  return is_numeric($v) ? $v : null;
}

$err = '';
$ok = false;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  csrf_check();

  foreach ($default as $k => $v) {
    if ($k === 'justificativa_outros') {
      $row[$k] = trim($_POST[$k] ?? '');
    } else {
      $row[$k] = $_POST[$k] ?? $v;
    }
  }

  $row['valor_unitario'] = fnum($row['valor_unitario']);
  $row['valor_total_previsto'] = fnum($row['valor_total_previsto']);
  $row['valor_total_realizado'] = fnum($row['valor_total_realizado']);

  $ints = [
    'pedido', 'realizado', 'chapa_reservada_faturada', 'contador_alimentacao', 'conferencia',
    'perda_setup', 'abaulada', 'impressao_nao_conforme', 'materia_prima', 'acabou_cola', 'acabou_tinta',
    'delaminacao', 'fora_de_esquadro', 'rasgada', 'enroscou', 'outros'
  ];
  foreach ($ints as $k) {
    $row[$k] = (int)($row[$k] ?? 0);
  }

  $row['perda_total'] = (
    (int)$row['perda_setup'] +
    (int)$row['abaulada'] +
    (int)$row['impressao_nao_conforme'] +
    (int)$row['materia_prima'] +
    (int)$row['acabou_cola'] +
    (int)$row['acabou_tinta'] +
    (int)$row['delaminacao'] +
    (int)$row['fora_de_esquadro'] +
    (int)$row['rasgada'] +
    (int)$row['enroscou'] +
    (int)$row['outros']
  );

  $base = max(1, (int)$row['chapa_reservada_faturada']);
  $row['perc_perda'] = round(($row['perda_total'] / $base) * 100, 2);
  $row['diferenca_alimentacao'] = (int)$row['contador_alimentacao'] - (int)$row['chapa_reservada_faturada'];

  if (!$row['op_trimb'] || !$row['cliente']) {
    $err = 'Preencha OP e Cliente.';
  } else {
    if ($id) {
      $sql = "UPDATE bi_perdas SET
        dt_producao=:dt_producao,
        op_trimb=:op_trimb,
        cliente=:cliente,
        pedido=:pedido,
        valor_unitario=:valor_unitario,
        valor_total_previsto=:valor_total_previsto,
        realizado=:realizado,
        valor_total_realizado=:valor_total_realizado,
        material=:material,
        chapa_reservada_faturada=:chapa_reservada_faturada,
        contador_alimentacao=:contador_alimentacao,
        conferencia=:conferencia,
        perda_setup=:perda_setup,
        abaulada=:abaulada,
        impressao_nao_conforme=:impressao_nao_conforme,
        materia_prima=:materia_prima,
        acabou_cola=:acabou_cola,
        acabou_tinta=:acabou_tinta,
        delaminacao=:delaminacao,
        fora_de_esquadro=:fora_de_esquadro,
        rasgada=:rasgada,
        enroscou=:enroscou,
        outros=:outros,
        perda_total=:perda_total,
        perc_perda=:perc_perda,
        diferenca_alimentacao=:diferenca_alimentacao,
        justificativa_outros=:justificativa_outros,
        updated_at=NOW()
      WHERE id=:id";

      $st = $pdo->prepare($sql);
      $row['id'] = $id;
      $st->execute($row);
      $ok = true;
    } else {
      $sql = "INSERT INTO bi_perdas (
        dt_producao, op_trimb, cliente, pedido,
        valor_unitario, valor_total_previsto, realizado, valor_total_realizado,
        material, chapa_reservada_faturada, contador_alimentacao, conferencia,
        perda_setup, abaulada, impressao_nao_conforme, materia_prima, acabou_cola, acabou_tinta,
        delaminacao, fora_de_esquadro, rasgada, enroscou, outros, perda_total, perc_perda,
        diferenca_alimentacao, justificativa_outros, created_by, created_at, updated_at
      ) VALUES (
        :dt_producao, :op_trimb, :cliente, :pedido,
        :valor_unitario, :valor_total_previsto, :realizado, :valor_total_realizado,
        :material, :chapa_reservada_faturada, :contador_alimentacao, :conferencia,
        :perda_setup, :abaulada, :impressao_nao_conforme, :materia_prima, :acabou_cola, :acabou_tinta,
        :delaminacao, :fora_de_esquadro, :rasgada, :enroscou, :outros, :perda_total, :perc_perda,
        :diferenca_alimentacao, :justificativa_outros, :created_by, NOW(), NOW()
      )";
      $st = $pdo->prepare($sql);
      $row['created_by'] = auth_user()['id'];
      $st->execute($row);
      $newId = (int)$pdo->lastInsertId();
      header('Location: ' . route_url('perdas_form', ['id' => $newId, 'ok' => 1]));
      exit;
    }
  }
}
if (isset($_GET['ok'])) {
  $ok = true;
}
?>
<section class="glass-card p-5 md:p-6">
  <div class="flex flex-wrap items-center justify-between gap-3">
    <div>
      <p class="text-xs uppercase tracking-[0.15em] text-mnc-muted"><?= $id ? 'Editar' : 'Novo' ?></p>
      <h1 class="mt-1 text-2xl font-extrabold">Registro de Perdas</h1>
    </div>
    <a class="btn-muted" href="<?= e(route_url('perdas')) ?>">Voltar</a>
  </div>
  <p class="mt-2 text-sm text-mnc-muted">Formulario preparado para receber os dados da planilha operacional.</p>
</section>

<?php if ($err): ?>
  <div class="mt-4 rounded-xl border border-red-300/40 bg-red-400/10 px-4 py-3 text-sm text-red-100"><?= e($err) ?></div>
<?php endif; ?>
<?php if ($ok): ?>
  <div class="mt-4 rounded-xl border border-emerald-300/40 bg-emerald-400/10 px-4 py-3 text-sm text-emerald-100">Salvo com sucesso.</div>
<?php endif; ?>

<form method="post" class="mt-4 grid gap-4" action="<?= e(route_url('perdas_form', ['id' => $id])) ?>">
  <input type="hidden" name="_csrf" value="<?= e(csrf_token()) ?>">

  <section class="glass-card p-5 md:p-6">
    <div class="grid gap-3 md:grid-cols-3">
      <div>
        <label class="mb-1 block text-xs font-semibold uppercase tracking-[0.12em] text-mnc-muted">Data de Producao</label>
        <input type="date" class="input-dark" name="dt_producao" value="<?= e(substr((string)$row['dt_producao'], 0, 10)) ?>" required>
      </div>
      <div>
        <label class="mb-1 block text-xs font-semibold uppercase tracking-[0.12em] text-mnc-muted">OP / Trimb</label>
        <input type="text" class="input-dark" name="op_trimb" value="<?= e($row['op_trimb']) ?>" required>
      </div>
      <div>
        <label class="mb-1 block text-xs font-semibold uppercase tracking-[0.12em] text-mnc-muted">Cliente</label>
        <input type="text" class="input-dark" name="cliente" value="<?= e($row['cliente']) ?>" required>
      </div>
    </div>

    <div class="mt-3 grid gap-3 md:grid-cols-5">
      <div>
        <label class="mb-1 block text-xs font-semibold uppercase tracking-[0.12em] text-mnc-muted">Pedido</label>
        <input type="number" class="input-dark" name="pedido" value="<?= e($row['pedido']) ?>">
      </div>
      <div>
        <label class="mb-1 block text-xs font-semibold uppercase tracking-[0.12em] text-mnc-muted">Valor Unitario</label>
        <input type="text" class="input-dark" name="valor_unitario" value="<?= e($row['valor_unitario']) ?>">
      </div>
      <div>
        <label class="mb-1 block text-xs font-semibold uppercase tracking-[0.12em] text-mnc-muted">Valor Previsto</label>
        <input type="text" class="input-dark" name="valor_total_previsto" value="<?= e($row['valor_total_previsto']) ?>">
      </div>
      <div>
        <label class="mb-1 block text-xs font-semibold uppercase tracking-[0.12em] text-mnc-muted">Realizado (un.)</label>
        <input type="number" class="input-dark" name="realizado" value="<?= e($row['realizado']) ?>">
      </div>
      <div>
        <label class="mb-1 block text-xs font-semibold uppercase tracking-[0.12em] text-mnc-muted">Valor Realizado</label>
        <input type="text" class="input-dark" name="valor_total_realizado" value="<?= e($row['valor_total_realizado']) ?>">
      </div>
    </div>

    <div class="mt-3">
      <label class="mb-1 block text-xs font-semibold uppercase tracking-[0.12em] text-mnc-muted">Material</label>
      <input type="text" class="input-dark" name="material" value="<?= e($row['material']) ?>">
    </div>

    <div class="mt-3 grid gap-3 md:grid-cols-3">
      <div>
        <label class="mb-1 block text-xs font-semibold uppercase tracking-[0.12em] text-mnc-muted">Chapa Reservada/Faturada</label>
        <input type="number" class="input-dark" name="chapa_reservada_faturada" value="<?= e($row['chapa_reservada_faturada']) ?>">
      </div>
      <div>
        <label class="mb-1 block text-xs font-semibold uppercase tracking-[0.12em] text-mnc-muted">Contador Alimentacao</label>
        <input type="number" class="input-dark" name="contador_alimentacao" value="<?= e($row['contador_alimentacao']) ?>">
      </div>
      <div>
        <label class="mb-1 block text-xs font-semibold uppercase tracking-[0.12em] text-mnc-muted">Conferencia</label>
        <input type="number" class="input-dark" name="conferencia" value="<?= e($row['conferencia']) ?>">
      </div>
    </div>
  </section>

  <section class="glass-card p-5 md:p-6">
    <h2 class="text-lg font-bold">Motivos de Perda (unidades)</h2>
    <div class="mt-3 grid gap-3 md:grid-cols-2 xl:grid-cols-4">
      <?php
      $motivos = [
        ['perda_setup', 'Perda Setup'],
        ['abaulada', 'Abaulada'],
        ['impressao_nao_conforme', 'Impressao nao conforme'],
        ['materia_prima', 'Materia prima'],
        ['acabou_cola', 'Acabou cola'],
        ['acabou_tinta', 'Acabou tinta'],
        ['delaminacao', 'Delaminacao'],
        ['fora_de_esquadro', 'Fora de esquadro'],
        ['rasgada', 'Rasgada'],
        ['enroscou', 'Enroscou'],
        ['outros', 'Outros'],
      ];
      foreach ($motivos as $m):
      ?>
        <div>
          <label class="mb-1 block text-xs font-semibold uppercase tracking-[0.12em] text-mnc-muted"><?= e($m[1]) ?></label>
          <input type="number" min="0" class="input-dark" name="<?= e($m[0]) ?>" value="<?= e($row[$m[0]]) ?>">
        </div>
      <?php endforeach; ?>
    </div>

    <div class="mt-3">
      <label class="mb-1 block text-xs font-semibold uppercase tracking-[0.12em] text-mnc-muted">Justificativa (Outros)</label>
      <textarea class="input-dark" name="justificativa_outros" rows="2"><?= e($row['justificativa_outros']) ?></textarea>
    </div>

    <div class="mt-5 grid gap-3 md:grid-cols-3">
      <div class="rounded-2xl border border-slate-200 bg-white p-4">
        <div class="kpi-value" id="calc_perda_total"><?= (int)$row['perda_total'] ?></div>
        <div class="kpi-label">Perda Total (auto)</div>
      </div>
      <div class="rounded-2xl border border-slate-200 bg-white p-4">
        <div class="kpi-value" id="calc_perc"><?= e(num($row['perc_perda'], 2)) ?>%</div>
        <div class="kpi-label">% Perda (auto)</div>
      </div>
      <div class="rounded-2xl border border-slate-200 bg-white p-4">
        <div class="kpi-value" id="calc_dif"><?= (int)$row['diferenca_alimentacao'] ?></div>
        <div class="kpi-label">Dif. Alimentacao (auto)</div>
      </div>
    </div>
  </section>

  <div class="flex flex-wrap justify-end gap-2">
    <button class="btn-primary px-6">Salvar</button>
    <a class="btn-muted px-6" href="<?= e(route_url('perdas')) ?>">Cancelar</a>
  </div>
</form>

<script>
function toInt(v) {
  const n = parseInt(v || '0', 10);
  return isNaN(n) ? 0 : n;
}

function recalc() {
  const names = [
    'perda_setup', 'abaulada', 'impressao_nao_conforme', 'materia_prima', 'acabou_cola', 'acabou_tinta',
    'delaminacao', 'fora_de_esquadro', 'rasgada', 'enroscou', 'outros'
  ];
  let total = 0;
  names.forEach(function (n) {
    const input = document.querySelector('[name="' + n + '"]');
    total += toInt(input ? input.value : 0);
  });
  document.getElementById('calc_perda_total').textContent = total.toLocaleString('pt-BR');

  const baseInput = document.querySelector('[name="chapa_reservada_faturada"]');
  const contInput = document.querySelector('[name="contador_alimentacao"]');
  const base = Math.max(1, toInt(baseInput ? baseInput.value : 0));
  const perc = (total / base) * 100;
  document.getElementById('calc_perc').textContent = perc.toLocaleString('pt-BR', { minimumFractionDigits: 2, maximumFractionDigits: 2 }) + '%';

  const dif = toInt(contInput ? contInput.value : 0) - toInt(baseInput ? baseInput.value : 0);
  document.getElementById('calc_dif').textContent = dif.toLocaleString('pt-BR');
}

Array.prototype.forEach.call(document.querySelectorAll('input[type="number"]'), function (inp) {
  inp.addEventListener('input', recalc);
});
recalc();
</script>

<?php require __DIR__ . '/_layout_bottom.php'; ?>
