<?php
// app/helpers.php

if (!function_exists('app_config')) {
    function app_config(): array {
        static $cfg = null;
        if ($cfg === null) {
            $cfg = require __DIR__ . '/config.php';
        }
        return $cfg;
    }
}

if (!function_exists('bi_modules')) {
    function bi_modules(): array {
        static $mods = null;
        if ($mods === null) {
            $mods = require __DIR__ . '/modules.php';
        }
        return $mods;
    }
}

if (!function_exists('current_module_key')) {
    function current_module_key(): string {
        $mods = bi_modules();
        $keys = array_keys($mods);
        $fallback = $keys[0] ?? 'perdas_v1';

        $candidate = (string)($_GET['m'] ?? ($_SESSION['module'] ?? $fallback));
        return array_key_exists($candidate, $mods) ? $candidate : $fallback;
    }
}

if (!function_exists('current_module')) {
    function current_module(): array {
        $mods = bi_modules();
        $key = current_module_key();
        return $mods[$key] ?? [];
    }
}

if (!function_exists('app_base_url')) {
    function app_base_url(): string {
        $base = (string)(app_config()['app']['base_url'] ?? '');
        return rtrim($base, '/');
    }
}

if (!function_exists('route_url')) {
    function route_url(string $page, array $params = []): string {
        $query = ['p' => $page];
        $module = current_module_key();
        if ($module) {
            $query['m'] = $module;
        }
        if ($params) {
            $query = array_merge($query, $params);
        }
        return 'index.php?' . http_build_query($query);
    }
}

if (!function_exists('e')) {
    function e($v): string {
        return htmlspecialchars((string)$v, ENT_QUOTES, 'UTF-8');
    }
}

if (!function_exists('money')) {
    function money($v): string {
        if ($v === null || $v === '') return 'R$ 0,00';
        return 'R$ ' . number_format((float)$v, 2, ',', '.');
    }
}

if (!function_exists('num')) {
    function num($v, $dec = 0): string {
        if ($v === null || $v === '') return '0';
        return number_format((float)$v, $dec, ',', '.');
    }
}
